SET TERM ^ ;
CREATE OR ALTER PROCEDURE TROVACATENA (
    ARTICOLO_INP Varchar(20),
    ESTENSIONE_INP Varchar(3),
    MAGAZZINO_INP Integer )
RETURNS (
    ARTICOLO Varchar(20),
    ESTENSIONE Varchar(3),
    QTAPRESENTE Integer,
    QTAUTILE Integer )
AS
declare variable DSQL varchar(3000);
declare variable IDCATENA integer;
declare variable IDAPERTURA integer;
declare variable QPRECARICATA integer;
declare variable QPRESCARICATA integer;
declare variable ORDINIFOR integer;
declare variable ORDINICLI integer;
declare variable QUANTITADIFETT integer;
declare variable SOMMAPRECARICHI smallint;
declare variable SOTTRAIPRESCARICHI smallint;
declare variable SOMMAORDF smallint;
declare variable SOTTRAIORDC smallint;
declare variable SOTTRAIDIFETTOSI smallint;
begin

     IF(estensione_inp IS NULL OR estensione_inp='')THEN
     BEGIN
        estensione_inp='0';
     END

     /*inizializzazione*/
     sommaprecarichi=0;
     SELECT TESTO
     FROM TABX
     WHERE NOME='SommaPrecarichi'
     INTO :sommaprecarichi;
     IF(sommaprecarichi IS NULL)THEN
        sommaprecarichi=0;

     sottraiprescarichi=0;     
     SELECT TESTO
     FROM TABX
     WHERE NOME='SottraiPrescarichi'
     INTO :sottraiprescarichi;
     IF(sottraiprescarichi IS NULL)THEN
        sottraiprescarichi=0;

     sommaordf=0;   
     SELECT TESTO
     FROM TABX
     WHERE NOME='SommaOrdF'
     INTO :sommaordf;
     IF(sommaordf IS NULL)THEN
        sommaordf=0;

     sottraiordc=0;    
     SELECT TESTO
     FROM TABX
     WHERE NOME='SottraiOrdC'
     INTO :sottraiordc;
     IF(sottraiordc IS NULL)THEN
        sottraiordc=0;

     sottraidifettosi=0;    
     SELECT TESTO
     FROM TABX
     WHERE NOME='SottraiDifettosi'
     INTO :sottraidifettosi;
     IF(sottraidifettosi IS NULL)THEN
        sottraidifettosi=0;


     DSQL='SELECT IDCATENA '||
        'FROM CATENECAMBICOD '||
        'WHERE (CODICEARTICOLO='''||articolo_inp||''') '||
        'AND(ESTENSIONE='''||estensione_inp||''') ';
        EXECUTE STATEMENT DSQL INTO IDCATENA;

     IF(IDCATENA IS NULL)THEN
       IDCATENA=-1;

      DSQL='SELECT C.codicearticolo,C.estensione '||
        'FROM CATENECAMBICOD C '||
        'WHERE C.idcatena='||:idcatena||' '||
        'ORDER BY C.livello ASC';
      FOR EXECUTE STATEMENT DSQL
      INTO :ARTICOLO,:estensione
      DO
      BEGIN

          IF(estensione IS NULL OR estensione='')THEN
          BEGIN
             estensione='0';
          END

          /*TROVO ULTIMA APERTURA DEL MAGAZZINO*/

          SELECT FIRST 1 coalesce(IDAPERTURA,0)
          FROM APERTUREMAG
          WHERE MAGAZZINO=:magazzino_inp
          ORDER BY IDAPERTURA DESC
          INTO :IDAPERTURA;


          /*TROVO QUANTITA UTILE*/

          SELECT QUANTITAPRESENTE, QPRECARICATA, QPRESCARICATA, ORDINIFOR, ORDINICLI, QUANTITADIFETT
          FROM PROGMAG
          WHERE (CODICE=:articolo)
          AND(MAGAZZINO=:magazzino_inp)
          AND(IDAPERTURA=:idapertura)
          AND COALESCE(ESTENSIONE,'0')=:estensione
          INTO :qtapresente, :qprecaricata, : qprescaricata, :ordinifor, :ordinicli, :quantitadifett;

          qtautile=qtapresente;

          IF(SommaPrecarichi=1)THEN
          BEGIN
              qtautile=qtautile+qprecaricata;
          END
          IF(SottraiPrescarichi=1)THEN
          BEGIN
              qtautile=qtautile-qprescaricata;
          END
          IF(SommaOrdF=1)THEN
          BEGIN
              qtautile=qtautile+ordinifor;
          END
          IF(SottraiOrdC=1)THEN
          BEGIN
              qtautile=qtautile-ordinicli;
          END
          IF(SottraiDifettosi=1)THEN
          BEGIN
              qtautile=qtautile-quantitadifett;
          END



          SUSPEND;
      END

end^
SET TERM ; ^


GRANT EXECUTE
 ON PROCEDURE TROVACATENA TO  SYSDBA;

